package com.tbyf.cdcengine2.oracle;

import com.tbyf.cdcengine2.core.AbstractCdcEngine;
import com.tbyf.cdcengine2.core.ChangeListener;
import com.tbyf.cdcengine2.core.ChangedRecord;
import com.tbyf.cdcengine2.core.Constants;
import io.debezium.connector.oracle.OracleConnector;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;

public class OracleCdcEngine extends AbstractCdcEngine<OracleCdcEngine> {

    static {
        OracleUtils.loadDriver();
    }

    public OracleCdcEngine(OracleCdcEngineProperties props) {
        debeziumProps.setProperty(Constants.CONNECTOR_CLASS_PROP, OracleConnector.class.getName());

        debeziumProps.setProperty(Constants.DATABASE_HISTORY_FILE_FILENAME_PROP, props.getNamespace() + "_his.dat");
        debeziumProps.setProperty(Constants.OFFSET_STORAGE_FILE_FILENAME_PROP, props.getNamespace() + "_off.dat");

        debeziumProps.setProperty("database.hostname", props.getHost());
        debeziumProps.setProperty("database.port", String.valueOf(props.getPort()));
        debeziumProps.setProperty("database.user", props.getUsername());
        debeziumProps.setProperty("database.password", props.getPassword());
        debeziumProps.setProperty("database.dbname", props.getDbname());

        debeziumProps.setProperty("log.mining.strategy", "online_catalog");
        debeziumProps.setProperty("snapshot.mode", "schema_only");

        debeziumProps.setProperty("database.history.skip.unparseable.ddl", Boolean.toString(true));
        debeziumProps.setProperty("database.history.store.only.captured.tables.ddl", Boolean.toString(true));

        String schema = props.getUsername().toUpperCase();
        debeziumProps.setProperty(Constants.SCHEMA_INCLUDE_LIST_PROP, schema);

        String capturedTables = new HashSet<>(Arrays.asList(props.getCapturedTables().toUpperCase().split(",")))
                .stream().map(tableName -> schema + "." + tableName)
                .collect(Collectors.joining(","));
        debeziumProps.setProperty(Constants.TABLE_INCLUDE_LIST_PROP, capturedTables);


        // 开启supplemental logging
        String url = OracleUtils.buildOracleJdbcUrl(props.getHost(), props.getPort(), props.getDbname());
        SupplementalLoggingUtils.enableDBSupplementalLogging(OracleUtils.getConn(url, props.getUsername(), props.getPassword()));
        SupplementalLoggingUtils.enableSchemaTablesSupplementalLogging(OracleUtils.getConn(url, props.getUsername(),
                        props.getPassword()), schema,
                new HashSet<>(Arrays.asList(props.getCapturedTables().split(","))));
    }

}
