package com.tbyf.cdcengine2.sqlserver;

import com.tbyf.cdcengine2.core.JdbcConnInfo;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlServerUtils {

    public static final String SQL_SERVER_DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String SQL_SERVER_URL_PATTERN = "jdbc:sqlserver://<host>:<port>";
    public static void loadDriver() {
        try {
            Class.forName(SQL_SERVER_DRIVER_CLASS_NAME);
        } catch (ClassNotFoundException e) {
            throw new IllegalStateException("未找到sqlserver jdbc驱动");
        }
    }

    public static String buildUrl(String host, String port) {
        return SQL_SERVER_URL_PATTERN.replace("<host>", host)
                .replace("<port>", port);
    }

    public static Connection getConn(String host, String port, String user, String password) {
        try {
            return DriverManager.getConnection(buildUrl(host, port), user, password);
        } catch (SQLException e) {
            throw new IllegalStateException("获取数据库连接失败", e);
        }
    }

    private static final Pattern urlPattern = Pattern.compile("jdbc:sqlserver://([a-zA-Z0-9.]+):(\\d+);databaseName=([a-zA-Z_]*)");

    public static JdbcConnInfo parseConnInfoFromUrl(String url) {
        Matcher matcher = urlPattern.matcher(url);
        if (matcher.find()) {
            String host = matcher.group(1);
            int port = Integer.parseInt(matcher.group(2));
            String dbname = matcher.group(3);
            JdbcConnInfo connInfo = new JdbcConnInfo();
            connInfo.setUrl(url);
            connInfo.setHost(host);
            connInfo.setPort(port);
            connInfo.setDbname(dbname);
            return connInfo;
        } else {
            throw new IllegalArgumentException(url);
        }
    }

}
