package com.tbyf.cdcengine2.oracle;

import com.tbyf.cdcengine2.core.AbstractCdcEngine;
import com.tbyf.cdcengine2.core.Constants;
import io.debezium.connector.oracle.OracleConnector;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;

public class OracleCdcEngine extends AbstractCdcEngine<OracleCdcEngine> {

    static {
        OracleUtils.loadDriver();
    }

    public OracleCdcEngine(OracleCdcEngineProperties props) {
        super(props);
        debeziumProps.setProperty(Constants.CONNECTOR_CLASS_PROP, OracleConnector.class.getName());
        debeziumProps.setProperty(Constants.DATABASE_DBNAME_PROP, props.getDbname());
        debeziumProps.setProperty("log.mining.strategy", "online_catalog");

        String schema = props.getUsername().toUpperCase();
        debeziumProps.setProperty(Constants.SCHEMA_INCLUDE_LIST_PROP, schema);

        String capturedTables = new HashSet<>(Arrays.asList(props.getCapturedTables().toUpperCase().split(",")))
                .stream().map(tableName -> schema + "." + tableName)
                .collect(Collectors.joining(","));
        debeziumProps.setProperty(Constants.TABLE_INCLUDE_LIST_PROP, capturedTables);


        // 开启supplemental logging
        String url = OracleUtils.buildOracleJdbcUrl(props.getHost(), props.getPort(), props.getDbname());
        SupplementalLoggingUtils.enableDBSupplementalLogging(OracleUtils.getConn(url, props.getUsername(), props.getPassword()));
        SupplementalLoggingUtils.enableSchemaTablesSupplementalLogging(OracleUtils.getConn(url, props.getUsername(),
                        props.getPassword()), schema,
                new HashSet<>(Arrays.asList(props.getCapturedTables().split(","))));
    }

}
