package com.tbyf.cdcengine2.sqlserver;

import com.tbyf.cdcengine2.core.AbstractCdcEngine;
import com.tbyf.cdcengine2.core.Constants;
import io.debezium.connector.sqlserver.SqlServerConnector;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;

public class SqlServerCdcEngine extends AbstractCdcEngine<SqlServerCdcEngine> {

    static {
        SqlServerUtils.loadDriver();
    }

    public SqlServerCdcEngine(SqlServerCdcEngineProperties props) {
        super(props);
        debeziumProps.setProperty(Constants.CONNECTOR_CLASS_PROP, SqlServerConnector.class.getName());
        debeziumProps.setProperty(Constants.DATABASE_DBNAME_PROP, props.getDbName());

        String schema = SqlServerCdcEngineProperties.DATABASE_OWNER_SCHEMA_NAME;
        String capturedTables = new HashSet<>(Arrays.asList(props.getCapturedTables().toUpperCase().split(",")))
                .stream().map(tableName -> schema + "." + tableName)
                .collect(Collectors.joining(","));
        debeziumProps.setProperty(Constants.TABLE_INCLUDE_LIST_PROP, capturedTables);

        try (Connection conn = SqlServerUtils.getConn(props.getHost(), String.valueOf(props.getPort()), props.getUsername(), props.getPassword())) {
            SqlServerCdcHelper.enableDBCdcIfNeeded(conn, props.getDbName());
            for (String table : props.getCapturedTables().split(",")) {
                SqlServerCdcHelper.enableTableCdcIfNeeded(conn, props.getDbName(), table);
            }
        } catch (SQLException ex) {
            throw new IllegalStateException("开启CDC失败", ex);
        }
    }

    public static void main(String[] args) {
        SqlServerCdcEngineProperties props = new SqlServerCdcEngineProperties();
        props.setHost("192.168.0.85");
        props.setPort(1433);
        props.setUsername("sa");
        props.setPassword("1");
        props.setDbName("dz_his");
        props.setCapturedTables("BA_BAJY");

        SqlServerCdcEngine engine = new SqlServerCdcEngine(props);
        engine.onChange(record -> {
            System.out.println(record);
        });
        engine.start();
    }
}
