package com.tbyf.cdcengine2.core;

import java.util.Map;
import java.util.Objects;

public class ChangedRecord {

    // DATACENTER.ADAPTER_CDC_COLUMN, 其中DATACENTER是schema, ADAPTER_CDC_COLUMN是table
    private String schema;
    private String table;

    private Map<String, Object> before;
    private Map<String, Object> now;
    private OperationType operationType;

    public String table() {
        return table;
    }

    public ChangedRecord table(String table) {
        this.table = table;
        return this;
    }

    public ChangedRecord schema(String schema) {
        this.schema = schema;
        return this;
    }

    public String schema() {
        return schema;
    }
    public boolean hasChanged() {
        if (before == null || now == null) {
            return true;
        }
        for (Map.Entry<String, Object> entry : before.entrySet()) {
            String key = entry.getKey();
            Object beforeValue = entry.getValue();
            Object nowValue = now.get(key);
            if (!Objects.equals(beforeValue, nowValue)) {
                return true;
            }
        }
        return false;
    }

    public ChangedRecord before(Map<String, Object> before) {
        this.before = before;
        return this;
    }

    public ChangedRecord now(Map<String, Object> now) {
        this.now = now;
        return this;
    }

    public Map<String, Object> before() {
        return before;
    }

    public Map<String, Object> now() {
        return now;
    }

    public OperationType operationType() {
        return operationType;
    }

    public ChangedRecord operationType(OperationType operationType) {
        this.operationType = operationType;
        return this;
    }


    @Override
    public String toString() {
        return "ChangedRecord{" +
                "schema='" + schema + '\'' +
                ", table='" + table + '\'' +
                ", before=" + before +
                ", now=" + now +
                ", operationType=" + operationType +
                '}';
    }
}
