package com.tbyf.cdcengine2.mysql;

import com.tbyf.cdcengine2.core.AbstractCdcEngine;
import com.tbyf.cdcengine2.core.Constants;
import io.debezium.connector.mysql.MySqlConnector;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;

public class MySqlCdcEngine extends AbstractCdcEngine<MySqlCdcEngine> {

    static {
        MySqlUtils.loadDriver();
    }

    public MySqlCdcEngine(MySqlCdcEngineProperties props) {
        super(props);
        debeziumProps.setProperty(Constants.CONNECTOR_CLASS_PROP, MySqlConnector.class.getName());
        debeziumProps.setProperty(Constants.DATABASE_DBNAME_PROP, props.getDbname());

        String dbname = props.getDbname();


        debeziumProps.setProperty("database.serverTimezone", "Asia/Shanghai");

        String capturedTables = new HashSet<>(Arrays.asList(props.getCapturedTables().toUpperCase().split(",")))
                .stream().map(tableName -> dbname + "." + tableName)
                .collect(Collectors.joining(","));
        debeziumProps.setProperty(Constants.TABLE_INCLUDE_LIST_PROP, capturedTables);
    }

    public static void main(String[] args) {
        MySqlCdcEngineProperties props = new MySqlCdcEngineProperties();
        props.setHost("localhost");
        props.setPort(3306);
        props.setUsername("root");
        props.setPassword("root");
        props.setDbname("easychat");
        props.setCapturedTables("app_update");

        new MySqlCdcEngine(props)
                .onChange(record -> {
                    System.out.println(record);
                }).start();
    }
}
