package com.tbyf.cdcengine2.oracle;

import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Collect;
import org.apache.kafka.connect.data.Struct;

import java.time.Instant;
import java.util.Map;

class OracleEventMetadataProvider implements EventMetadataProvider {
    OracleEventMetadataProvider() {
    }

    public Instant getEventTimestamp(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        } else {
            Struct sourceInfo = value.getStruct("source");
            if (source == null) {
                return null;
            } else {
                Long timestamp = sourceInfo.getInt64("ts_ms");
                return timestamp == null ? null : Instant.ofEpochMilli(timestamp);
            }
        }
    }

    public Map<String, String> getEventSourcePosition(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        } else {
            Struct sourceInfo = value.getStruct("source");
            if (source == null) {
                return null;
            } else {
                String scn = sourceInfo.getString("scn");
                return Collect.hashMapOf("scn", scn == null ? "null" : scn);
            }
        }
    }

    public String getTransactionId(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        } else {
            Struct sourceInfo = value.getStruct("source");
            return source == null ? null : sourceInfo.getString("txId");
        }
    }
}

