package com.tbyf.cdcengine2.oracle;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.pipeline.spi.Partition;

import java.util.Collections;
import java.util.Set;

public class Provider implements Partition.Provider<OraclePartition> {
    private final OracleConnectorConfig connectorConfig;

    Provider(OracleConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public Set<OraclePartition> getPartitions() {
        return Collections.singleton(new OraclePartition(this.connectorConfig.getLogicalName()));
    }
}
