package com.tbyf.cdcengine2.sqlserver;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class SqlServerUtils {

    public static final String SQL_SERVER_DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String SQL_SERVER_URL_PATTERN = "jdbc:sqlserver://<host>:<port>";
    public static void loadDriver() {
        try {
            Class.forName(SQL_SERVER_DRIVER_CLASS_NAME);
        } catch (ClassNotFoundException e) {
            throw new IllegalStateException("未找到sqlserver jdbc驱动");
        }
    }

    public static String buildUrl(String host, String port) {
        return SQL_SERVER_URL_PATTERN.replace("<host>", host)
                .replace("<port>", port);
    }

    public static Connection getConn(String host, String port, String user, String password) {
        try {
            return DriverManager.getConnection(buildUrl(host, port), user, password);
        } catch (SQLException e) {
            throw new IllegalStateException("获取数据库连接失败", e);
        }
    }
}
