package com.tbyf.cdcengine2.oracle;

public class OracleCdcEngineProperties {

    private String host;
    private int port;
    private String dbname;
    private String username;
    private String password;
    private String cdcTables;
    private String namespace;

    public OracleCdcEngineProperties namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String namespace() {
        if (namespace == null) {
            return "default";
        }
        return namespace;
    }

    public OracleCdcEngineProperties host(String host) {
        this.host = host;
        return this;
    }

    public OracleCdcEngineProperties port(int port) {
        this.port = port;
        return this;
    }

    public OracleCdcEngineProperties dbname(String dbname) {
        this.dbname = dbname;
        return this;
    }

    public OracleCdcEngineProperties username(String username) {
        this.username = username;
        return this;
    }

    public OracleCdcEngineProperties password(String password) {
        this.password = password;
        return this;
    }

    public OracleCdcEngineProperties cdcTables(String cdcTables) {
        this.cdcTables = cdcTables;
        return this;
    }

    public String host() {
        return host;
    }

    public int port() {
        return port;
    }

    public String dbname() {
        return dbname;
    }

    public String username() {
        return username;
    }

    public String password() {
        return password;
    }

    public String cdcTables() {
        return cdcTables;
    }
}
