package com.tbyf.cdcengine2.mysql;

import com.tbyf.cdcengine2.core.JdbcConnInfo;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MySqlUtils {

    public static void loadDriver() {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        } catch (ClassNotFoundException e) {
            throw new IllegalStateException("未找到mysql jdbc驱动", e);
        }
    }

    public static String buildUrl(String host, int port, String database) {
        return "jdbc:mysql://" + host + ":" + port + "/" + database + "?serverTimezone=Asia/Shanghai";
    }


    private static final Pattern urlPattern = Pattern.compile("jdbc:mysql://([a-zA-Z0-9.]+):(\\d+)/([a-zA-Z]+)\\?*.*");

    public static JdbcConnInfo parseConnInfoFromUrl(String url) {
        Matcher matcher = urlPattern.matcher(url);
        if (matcher.find()) {
            String host = matcher.group(1);
            int port = Integer.parseInt(matcher.group(2));
            String dbname = matcher.group(3);

            JdbcConnInfo connInfo = new JdbcConnInfo();
            connInfo.setUrl(url);
            connInfo.setHost(host);
            connInfo.setPort(port);
            connInfo.setDbname(dbname);
            return connInfo;
        } else {
            throw new IllegalArgumentException(url);
        }
    }

}
