package com.tbyf.cdcengine2.oracle;

import com.tbyf.cdcengine2.core.JdbcConnInfo;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleUtils {

    private static final Pattern urlPattern = Pattern.compile("jdbc:oracle:thin:@([a-zA-Z0-9.]+):(\\d+):([a-zA-Z]+)");

    public static JdbcConnInfo parseConnInfoFromUrl(String url) {
        Matcher matcher = urlPattern.matcher(url);
        if (matcher.find()) {
            String host = matcher.group(1);
            int port = Integer.parseInt(matcher.group(2));
            String dbname = matcher.group(3);

            JdbcConnInfo connInfo = new JdbcConnInfo();
            connInfo.setUrl(url);
            connInfo.setHost(host);
            connInfo.setPort(port);
            connInfo.setDbname(dbname);
            return connInfo;
        } else {
            throw new IllegalArgumentException(url);
        }
    }
}
