package com.tbyf.cdcengine2.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SqlServerCdcHelper {

    private static final String SWITCH_DB_SQL = "USE <dbName>";

    private static final String DB_CDC_ENABLED_QUERY_SQL =
            "SELECT is_cdc_enabled \n" +
                    "FROM sys.databases \n" +
                    "WHERE name = '${dbName}'";

    private static final String ENABLE_DB_CDC_SQL =
            "EXEC sys.sp_cdc_enable_db";

    private static final String TABLE_CDC_ENABLED_QUERY_SQL =
            "SELECT is_tracked_by_cdc \n" +
                    "FROM sys.tables \n" +
                    "WHERE name = '${tableName}' AND schema_id = SCHEMA_ID('dbo')";

    private static final String ENABLE_TABLE_CDC_SQL =
            "EXEC sys.sp_cdc_enable_table \n" +
                    "@source_schema = N'dbo', \n" +
                    "@source_name   = N'${tableName}', \n" +
                    "@role_name     = N'NULL', \n" +   // TODO role_name
                    "@supports_net_changes = 0";


    public static boolean isDBCdcEnabled(Connection conn, String dbName) {
        try (Statement stmt = conn.createStatement()) {
            switchDB(stmt, dbName);
            String sql = DB_CDC_ENABLED_QUERY_SQL.replace("${dbName}", dbName);
            try (ResultSet rs = stmt.executeQuery(sql)) {
                if (rs.next()) {
                    return rs.getInt(1) == 1;
                } else {
                    throw new IllegalStateException("未查询到数据库CDC开启状态");
                }
            }
        } catch (SQLException e) {
            throw new IllegalStateException("查询数据库CDC开启状态时发生了异常", e);
        }
    }



    public static void enableDBCdcIfNeeded(Connection conn, String dbName) {
        if (!isDBCdcEnabled(conn, dbName)) {
            enableDBCdc(conn, dbName);
        }
    }

    public static void enableDBCdc(Connection conn, String dbName) {
        try (Statement stmt = conn.createStatement()) {
            switchDB(stmt, dbName);
            stmt.execute(ENABLE_DB_CDC_SQL);
        } catch (SQLException e) {
            throw new IllegalStateException("开启数据库CDC失败", e);
        }
    }

    // 查询表是否开启了CDC
    public static boolean isTableCdcEnabled(Connection conn, String dbName, String tableName) {
        try (Statement stmt = conn.createStatement()) {
            switchDB(stmt, dbName);
            String sql = TABLE_CDC_ENABLED_QUERY_SQL.replace("${tableName}", tableName);
            try (ResultSet rs = stmt.executeQuery(sql)) {
                if (rs.next()) {
                    return rs.getInt(1) == 1;
                } else {
                    throw new IllegalStateException("未查询到表CDC开启状态");
                }
            }
        } catch (SQLException e) {
            throw new IllegalStateException("查询表CDC开启状态时发生了异常", e);
        }
    }

    public static void enableTableCdc(Connection conn, String dbName, String tableName) {
        try (Statement stmt = conn.createStatement()) {
            switchDB(stmt, dbName);
            String sql = ENABLE_TABLE_CDC_SQL.replace("${tableName}", tableName);
            stmt.execute(sql);
        } catch (SQLException e) {
            throw new IllegalStateException("开启表CDC失败", e);
        }
    }

    public static void enableTableCdcIfNeeded(Connection conn, String dbName, String tableName) {
        if (!isTableCdcEnabled(conn, dbName, tableName)) {
            enableTableCdc(conn, dbName, tableName);
        }
    }

    private static void switchDB(Statement stmt, String dbName) throws SQLException {
        String sql = SWITCH_DB_SQL.replace("<dbName>", dbName);
        stmt.execute(sql);
    }

}
