package com.tbyf.dataadapter.console.controlle;

import com.tbyf.dataadapter.api.vo.Result;
import com.tbyf.dataadapter.console.model.dto.GroupDTO;
import com.tbyf.dataadapter.registry.GroupNode;
import com.tbyf.dataadapter.registry.WorkerRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/worker")
public class WorkerController {

    @Autowired
    WorkerRegistry workerRegistry;

    @GetMapping("/groups")
    public Result<?> getWorkerGroups() {
        List<GroupNode> workerGroups = workerRegistry.getWorkerGroups();
        return Result.ok(workerGroups.stream().map(g->{
            GroupDTO dto = new GroupDTO();
            dto.setName(g.getName());
            dto.setWorkerNodes(new ArrayList<>(g.getWorkerNodes().values()));
            return dto;
        }).collect(Collectors.toList()));
    }
}
