package com.tbyf.dataadapter.api.vo;

import com.google.gson.Gson;
import lombok.Data;

@Data
public class Result<T> {
    private T data;
    private String msg;
    private int code;

    public static <T> Result<T> ok(T data) {
        return build(data, "ok", 200);
    }

    private static <T> Result<T> build(T data, String msg, int code) {
        Result<T> r = new Result<>();
        r.data = data;
        r.msg = msg;
        r.code = code;
        return r;
    }

}
