package com.tbyf.dataadapter.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;

public class NetUtils {

    public static String localhost;

    public static String getLocalHost() throws UnknownHostException {
        if (localhost != null) {
            return localhost;
        }
        synchronized (NetUtils.class) {
            if (localhost != null) {
                return localhost;
            }
            localhost = new String(InetAddress.getLocalHost().getHostAddress().getBytes(), StandardCharsets.UTF_8);
            return localhost;
        }
    }
}
