package com.tbyf.dataadapter.app;

import com.tbyf.dataadapter.Worker;
import com.tbyf.dataadapter.WorkerApiRequestHandler;
import com.tbyf.dataadapter.WorkerProperties;
import com.tbyf.dataadapter.api.impl.WorkerBizImpl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class WorkerBootstrap {

    public static void main(String[] args) {
        Properties props = loadProps();
        WorkerProperties wp = new WorkerProperties();
        wp.setName(props.getProperty("name"));
        wp.setGroup(props.getProperty("group"));
        wp.setRegistryAddress(props.getProperty("registryAddress"));
        wp.setPort(Integer.parseInt(props.getProperty("port")));
        Worker worker = new Worker(wp);
        WorkerApiRequestHandler handler = new WorkerApiRequestHandler(new WorkerBizImpl(props.getProperty("pluginsRoot"), props.getProperty("pluginRepositoryUrl")));
        worker.setRequestHandler(handler);
        worker.start();
    }

    private static Properties loadProps() {
        ClassLoader cld = WorkerBootstrap.class.getClassLoader();
        Properties props = new Properties();
        try (InputStream is = cld.getResourceAsStream("worker.conf")) {
            props.load(is);
        } catch (IOException e) {
        }
        return props;

    }
}
