package com.tbyf.dataadapter;

import com.tbyf.dataadapter.api.WorkerBizApi;
import com.tbyf.dataadapter.api.vo.Result;
import com.tbyf.dataadapter.http.HttpRequest;
import com.tbyf.dataadapter.http.HttpResponse;
import com.tbyf.dataadapter.http.RequestHandler;
import com.tbyf.dataadapter.task.TaskDef;
import com.tbyf.dataadapter.util.JsonUtils;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WorkerApiRequestHandler implements RequestHandler {

    private final WorkerBizApi workerBizApi;


    public WorkerApiRequestHandler(WorkerBizApi workerBizApi) {
        this.workerBizApi = workerBizApi;
    }

    @Override
    public HttpResponse handle(HttpRequest request) throws Exception {
        Object result = null;
        switch (request.getUri()) {
            case "/installPlugin":
                result = workerBizApi.installPlugin(request.getContent());
                break;
            case "/submitTask":
                TaskDef def = JsonUtils.fromJson(request.getContent(), TaskDef.class);
                result = workerBizApi.submitTask(def);
                break;
            case "/startTask":
                result = workerBizApi.startTask(request.getContent());
                break;
            case "/stopTask":
                result = workerBizApi.stopTask(request.getContent());
                break;
            case "/getProcessors":
                result = workerBizApi.getProcessors();
                break;
            case "/getHeadProcessors":
                result = workerBizApi.getHeadProcessors();
                break;
            case "/getTasks":
                result = workerBizApi.getTasks();
                break;
        }
        if (result == null) {
            return HttpResponse.NOT_FOUND;
        } else {
            return HttpResponse.json(JsonUtils.toJson(result));
        }
    }
}
