package com.tbyf.dataadapter.http;

import lombok.Data;

@Data
public class HttpResponse {

    public static String EMPTY_CONTENT = "";

    public static HttpResponse EMPTY_RESPONSE = textHtml(EMPTY_CONTENT);

    public static HttpResponse NOT_FOUND = textHtml("404");

    public static HttpResponse ERROR = textHtml("500");

    private String content;
    private String contentType;

    private static HttpResponse build(String content, String contentType) {
        HttpResponse response = new HttpResponse();
        response.content = content;
        response.contentType = contentType;
        return response;
    }

    public static HttpResponse json(String json) {
        return build(json, ContentType.APPLICATION_JSON);
    }

    public static HttpResponse textHtml(String textHtml) {
        return build(textHtml, ContentType.TEXT_HTML);
    }
}
