package com.tbyf.dataadapter.api;

import com.tbyf.dataadapter.api.vo.ProcessorVo;
import com.tbyf.dataadapter.api.vo.Result;
import com.tbyf.dataadapter.task.Task;
import com.tbyf.dataadapter.task.TaskDef;

import java.util.List;

public interface WorkerBizApi {

    /**
     * install plugin from remote plugin repository
     */
    Result<Boolean> installPlugin(String pluginId);

    Result<Boolean> submitTask(TaskDef taskDef);

    Result<Boolean> startTask(String taskId);

    Result<Boolean> stopTask(String taskId);

    Result<Boolean> pauseTask(String taskId);

    Result<Boolean> resumeTask(String taskId);

    Result<List<Task>> getTasks();

    Result<List<ProcessorVo>> getProcessors();

    Result<List<ProcessorVo>> getHeadProcessors();
}
