package com.tbyf.dataadapter.registry.support;

import com.tbyf.dataadapter.Worker;

public class ZkPathHelper {

    public static final String TOP_ROOT_PATH = "/tbyf";

    public static final String WORKER_GROUP_ROOT_PATH = TOP_ROOT_PATH + "/group";
    public static final String WORKER_GROUP_LOCK_PATH = TOP_ROOT_PATH + "/groupLock";

    public static String getWorkerPath(Worker worker) {
        return WORKER_GROUP_ROOT_PATH + "/" + worker.getGroup() + "/" + worker.getName();
    }

    public static String getGroupPath(String groupName) {
        return WORKER_GROUP_ROOT_PATH + "/" + groupName;
    }

    /**
     * lock path for worker doing sth exclusively with other worker in same group
     */
    public static String getLockPathForWorkerInGroup(String groupName, String lockName) {
        return WORKER_GROUP_LOCK_PATH + "/" + lockName + "/" + groupName;
    }
}
