package com.tbyf.dataadapter;

import com.tbyf.dataadapter.api.impl.WorkerBizImpl;
import com.tbyf.dataadapter.http.HttpRequest;
import com.tbyf.dataadapter.http.HttpResponse;
import com.tbyf.dataadapter.http.RequestHandler;
import com.tbyf.dataadapter.http.SimpleHttpServer;
import com.tbyf.dataadapter.registry.WorkerRegistry;
import com.tbyf.dataadapter.registry.support.ZookeeperWorkerRegistry;
import com.tbyf.dataadapter.util.NetUtils;
import lombok.Getter;
import lombok.Setter;

import java.net.UnknownHostException;
import java.util.UUID;

public class Worker {

    private final WorkerProperties props;

    @Getter
    private final String name;

    @Getter
    private final String group;

    @Getter
    private final String embeddedServerAddress;

    private final WorkerRegistry workerRegistry;

    @Setter
    private RequestHandler requestHandler;


    public Worker(WorkerProperties props) {
        props.validate();
        this.props = props;
        this.name = props.getName();
        this.group = props.getGroup();
        this.workerRegistry = new ZookeeperWorkerRegistry(props.getRegistryAddress());
        try {
            this.embeddedServerAddress = NetUtils.getLocalHost() + ":" + props.getPort();
        } catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        RequestHandler requestHandler = this.requestHandler;
        if (requestHandler == null) {
            throw new IllegalStateException("requestHandler not set");
        }
        workerRegistry.registerWorker(this);
        SimpleHttpServer server = new SimpleHttpServer(props.getPort(), requestHandler);
        server.start();
    }

    public static void main(String[] args) {
        WorkerProperties props = new WorkerProperties();
        Worker worker = new Worker(props);
        WorkerApiRequestHandler handler = new WorkerApiRequestHandler(new WorkerBizImpl("plugins001", "http://localhost:8082/plugin/download"));
        worker.setRequestHandler(handler);
        worker.start();
    }
}
