package com.tbyf.dataadapter.console.config;

import com.tbyf.dataadapter.registry.WorkerRegistry;
import com.tbyf.dataadapter.registry.support.ZookeeperWorkerRegistry;
import com.tbyf.dataadapter.task.processor.plugin.ProcessorManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DataAdapterConsoleConfig {

    @Value("${pluginsRepoLocation}")
    private String pluginsRoot;

    @Value("${zk}")
    private String zk;

    @Bean
    public ProcessorManager processorManager() {
        ProcessorManager.setPluginsRoot(pluginsRoot);
        ProcessorManager processorManager = new ProcessorManager();
        processorManager.start();
        return processorManager;
    }

    @Bean
    public WorkerRegistry workerRegistry() {
        return new ZookeeperWorkerRegistry(zk);
    }
}
