package com.tbyf.dataadapter.console.controlle;

import com.tbyf.dataadapter.api.impl.WorkerBizClient;
import com.tbyf.dataadapter.api.vo.Result;
import com.tbyf.dataadapter.console.model.dto.GroupDTO;
import com.tbyf.dataadapter.console.model.dto.TaskDefDTO;
import com.tbyf.dataadapter.registry.GroupNode;
import com.tbyf.dataadapter.registry.WorkerNode;
import com.tbyf.dataadapter.registry.WorkerRegistry;
import com.tbyf.dataadapter.task.TaskDef;
import com.tbyf.dataadapter.task.processor.config.PipelineDef;
import com.tbyf.dataadapter.task.processor.config.ProcessorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/worker")
public class WorkerController {

    @Autowired
    WorkerRegistry workerRegistry;

    @GetMapping("/groups")
    public Result<?> getWorkerGroups() {
        List<GroupNode> workerGroups = workerRegistry.getWorkerGroups();
        return Result.ok(workerGroups.stream().map(g -> {
            GroupDTO dto = new GroupDTO();
            dto.setName(g.getName());
            dto.setWorkerNodes(new ArrayList<>(g.getWorkerNodes().values()));
            return dto;
        }).collect(Collectors.toList()));
    }

    @GetMapping("/tasks")
    public Result<?> getTasks(String group, String worker) {
        WorkerNode workerNode = workerRegistry.getWorker(group, worker);
        if (workerNode != null) {
            WorkerBizClient client = workerNode.getClient();
            return client.getTasks();
        }
        return Result.ok(Collections.emptyList());
    }

    @GetMapping("/headProcessors")
    public Result<?> getHeadProcessors(String group, String worker) {
        WorkerNode workerNode = workerRegistry.getWorker(group, worker);
        if (workerNode != null) {
            WorkerBizClient client = workerNode.getClient();
            return client.getHeadProcessors();
        }
        return Result.ok(Collections.emptyList());
    }

    @GetMapping("/processors")
    public Result<?> getProcessors(String group, String worker) {
        WorkerNode workerNode = workerRegistry.getWorker(group, worker);
        if (workerNode != null) {
            WorkerBizClient client = workerNode.getClient();
            return client.getProcessors();
        }
        return Result.ok(Collections.emptyList());
    }

    @PostMapping("/installPlugin")
    public Result<?> installPlugin(String group, String worker, String pluginId) {
        WorkerNode workerNode = workerRegistry.getWorker(group, worker);
        if (workerNode != null) {
            WorkerBizClient client = workerNode.getClient();
            return client.installPlugin(pluginId);
        }
        return Result.ok(false);
    }

    @PostMapping("/submitTask")
    public Result<?> addTask(@RequestBody TaskDefDTO task) {
        WorkerNode workerNode = workerRegistry.getWorker(task.getGroup(), task.getWorker());
        if (workerNode != null) {
            WorkerBizClient client = workerNode.getClient();
            TaskDef taskDef = new TaskDef();
            taskDef.setTaskId(UUID.randomUUID().toString());
            taskDef.setDescription(task.getDescription());
            // todo
            taskDef.setParallelism(1);
            PipelineDef pd = new PipelineDef();
            pd.setHead(task.getHeadProcessor());
            pd.setProcessors(task.getProcessors());
            taskDef.setPipelineDef(pd);
            return client.submitTask(taskDef);
        }
        return Result.ok(false);
    }
}
