package com.tbyf.dataadapter.console.controlle;

import com.tbyf.dataadapter.task.processor.plugin.ProcessorManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.nio.file.Files;
import java.nio.file.Path;

@RestController
@RequestMapping("/plugin")
public class PluginController {

    @Autowired
    ResourceLoader resourceLoader;

    @Autowired
    ProcessorManager processorManager;

    @GetMapping("/download/{pluginId}")
    public ResponseEntity<?> download(@PathVariable String pluginId) {
        Path pluginPath = this.processorManager.getPluginPath(pluginId);
        if (pluginPath == null || !Files.exists(pluginPath)) {
            return ResponseEntity.notFound().build();
        }

        Resource resource = this.resourceLoader.getResource(ResourceUtils.FILE_URL_PREFIX + pluginPath);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentDisposition(
                ContentDisposition.attachment()
                        .filename(pluginPath.getFileName().toString())
                        .build());

        return ResponseEntity.ok()
                .headers(headers)
                .contentType(MediaType.APPLICATION_OCTET_STREAM)
                .body(resource);
    }
}
