package com.tbyf.dataadapter.console.controlle;

import com.tbyf.dataadapter.api.vo.Result;
import com.tbyf.dataadapter.registry.GroupNode;
import com.tbyf.dataadapter.registry.WorkerRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/worker")
public class WorkerController {

    @Autowired
    WorkerRegistry workerRegistry;

    @GetMapping("/groups")
    public Result<?> getWorkerGroups() {
        List<GroupNode> workerGroups = workerRegistry.getWorkerGroups();
        return Result.ok(workerGroups);
    }
}
