package com.tbyf.dataadapter.task.processor.plugin;

import com.tbyf.dataadapter.task.processor.Configuration;
import com.tbyf.dataadapter.task.processor.DataProcessor;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;

@Extension
public abstract class DataProcessorExtension implements DataProcessor, ExtensionPoint {

    protected ClassLoader pluginClassLoader;

    /**
     * the plugin classloader that loaded the plugin where this processor in
     */
    public ClassLoader getPluginClassLoader() {
        return pluginClassLoader;
    }

    public void setPluginClassLoader(ClassLoader cld) {
        pluginClassLoader = cld;
    }

    public String description() {
        return getClass().getName();
    }

    @Override
    public final void configure(Configuration config) {
        ClassLoader cur = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(getPluginClassLoader());
            doConfigure(config);
        } finally {
            Thread.currentThread().setContextClassLoader(cur);
        }
    }

    protected abstract void doConfigure(Configuration config);

}
