package com.tbyf.dataadapter.util;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;

import java.nio.charset.StandardCharsets;

/**
 * a helper class that makes it easy to interact with zookeeper
 */
public class ZkUtils {

    /**
     * create a ephemeral ZNode
     *
     * @param zkClient
     * @param path
     * @param data
     */
    public static void createEphemeralZNode(CuratorFramework zkClient, String path, String data) {
        createZNode(zkClient, path, true, data);
    }

    public static void createZNode(CuratorFramework zkClient, String path, boolean deleteOnDisconnect, String data) {
        CreateMode createMode = deleteOnDisconnect ? CreateMode.EPHEMERAL : CreateMode.PERSISTENT;
        try {
            zkClient.create()
                    .creatingParentsIfNeeded()
                    .withMode(createMode)
                    .forPath(path, data.getBytes(StandardCharsets.UTF_8));
        } catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void runWithinDistributedLock(CuratorFramework zkClient, String lockPath, Runnable task) {
        InterProcessMutex lock = new InterProcessMutex(zkClient, lockPath);
        try {
            lock.acquire();
            task.run();
        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            try {
                lock.release();
            } catch (Exception e) {
                // todo: how to deal with lock released failed
            }
        }
    }


    public static boolean exists(CuratorFramework zkClient, String path) {
        Stat stat = null;
        try {
            stat = zkClient.checkExists().forPath(path);
        } catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return stat != null;
    }
}
