package com.tbyf.dataadapter;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@Data
public class WorkerProperties {

    /**
     * unique name in the group
     */
    private String name = "worker0";

    /**
     * the group that this worker belonged to
     */
    private String group = "group0";

    private String registryAddress = "127.0.0.1:2181";

    /**
     * the embedded http server's port within this worker
     */
    private int port = 8081;

    public void validate() {
        if (StringUtils.isBlank(name)) {
            throw new IllegalStateException("name not set");
        }

        if (StringUtils.isBlank(group)) {
            throw new IllegalStateException("group not set");
        }

        if (StringUtils.isBlank(registryAddress)) {
            throw new IllegalStateException("registryAddress not set");
        }
    }

}
