package com.tbyf.dataadapter.task;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;

@Slf4j
public class TaskThread extends Thread {

    private volatile boolean paused = false;
    private volatile boolean terminated = false;

    private final Runnable task;

    private final List<Runnable> shutdownHooks = new ArrayList<>();

    public TaskThread(String taskId, Runnable task) {
        setName(taskId);
        this.task = task;
    }

    public void addShutdownHook(Runnable hook) {
        shutdownHooks.add(hook);
    }

    public void pause() {
        paused = true;
    }

    public void proceed() {
        paused = false;
    }

    public void terminate() {
        terminated = true;
        for (Runnable hook : shutdownHooks) {
            hook.run();
        }
    }


    @Override
    public void run() {
        while (!terminated) {
            while (paused && !terminated) {
                try {
                    Thread.sleep(500);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (terminated) {
                break;
            }

            try {
                task.run();
            } catch (Throwable e) {
                log.error(e.getMessage(), e);
                terminate();
                return;
            }
            try {
                Thread.sleep(500);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}
