package com.tbyf.dataadapter.task.processor;

import com.google.gson.Gson;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;

public class Configuration {

    private final Properties props;

    public Configuration(Properties props) {
        this.props = props;
    }


    public String getString(String key) {
        return props.getProperty(key);
    }

    public Integer getInt(String key) {
        String val = props.getProperty(key);
        return val == null ? null : Integer.parseInt(val);
    }

    public <T> T getObject(String key, Class<T> type) {
        String val = props.getProperty(key);
        if (val == null) {
            return null;
        }
        Gson gson = new Gson();
        return gson.fromJson(val, type);
    }

    public static Configuration from(String str) {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(str));
        } catch (Exception e) {
        }

        return new Configuration(properties);
    }
}
