package com.tbyf.dataadapter.task.processor;

import lombok.Setter;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultProcessorContext implements ProcessorContext {

    private final ProcessorPipeline pipeline;

    private final List<Runnable> shutdownHooks = new ArrayList<>();

    private final AtomicBoolean shutdown = new AtomicBoolean();

    public void addShutdownHook(Runnable hook) {
        shutdownHooks.add(hook);
    }

    public DefaultProcessorContext(ProcessorPipeline pipeline) {
        this.pipeline = pipeline;
    }

    @Override
    public void fireNext(Object data) {
        DataProcessor next = pipeline.nextProcessor();
        if (next != null) {
            next.process(this, data);
        }
    }

    @Override
    public void terminate() {
        if (shutdown.compareAndSet(false, true)) {
            for (Runnable hook : shutdownHooks) {
                hook.run();
            }
        }
    }

}
