package com.tbyf.dataadapter.task.processor;

import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;

@Slf4j
public class DefaultProcessorPipeline implements ProcessorPipeline {

    private final HeadProcessor head;

    private final List<DataProcessor> processors = new ArrayList<>();
    private volatile DataProcessor[] _processors;

    // todo: consider using thread local to store this variable
//    private int curPtr = 0;

    private static final ThreadLocal<Integer> curPtr = ThreadLocal.withInitial(() -> 0);

    private ProcessorContext ctx;

    public DefaultProcessorPipeline(HeadProcessor head) {
        this.head = head;
    }

    @Override
    public void addLast(DataProcessor processor) {
        processors.add(processor);
    }

    @Override
    public ProcessorContext context() {
        if (ctx != null) {
            return ctx;
        }
        synchronized (this) {
            if (ctx != null) {
                return ctx;
            }
            ctx = new DefaultProcessorContext(this);
            return ctx;
        }
    }

    @Override
    public HeadProcessor headProcessor() {
        return head;
    }

    @Override
    public void process() {
        // freeze the processors after first processing
        if (this._processors == null) {
            synchronized (this) {
                if (this._processors == null) {
                    this._processors = this.processors.toArray(new DataProcessor[0]);
                }
            }
        }
        curPtr.set(0);
        headProcessor().process(context(), null);
    }

    @Override
    public DataProcessor nextProcessor() {
        DataProcessor[] _processors = this._processors;
        if (_processors == null || _processors.length == 0) {
            return null;
        }
        Integer cur = curPtr.get();
        if (cur >= _processors.length) {
            return null;
        }
        DataProcessor result = _processors[cur];
        curPtr.set(cur + 1);
        return result;
    }



}
