package com.tbyd.data.datasync.core;

import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import org.apache.kafka.connect.source.SourceRecord;

import java.util.List;

public interface RecordHandler {

    boolean supports(ChangeEvent<SourceRecord, SourceRecord> record);

    void handle(ChangeEvent<SourceRecord, SourceRecord> record);

    default void handleBatch(List<ChangeEvent<SourceRecord, SourceRecord>> records, DebeziumEngine.RecordCommitter<ChangeEvent<SourceRecord, SourceRecord>> committer) throws Exception {
        for (ChangeEvent<SourceRecord, SourceRecord> record : records) {
            committer.markProcessed(record);
            if (supports(record)) {
                handle(record);
            }
        }
        committer.markBatchFinished();
    }
}
