package com.tbyd.data.datasync;

import com.tbyd.data.datasync.config.DataSyncProperties;
import com.tbyd.data.datasync.config.DebeziumProperties;
import com.tbyd.data.datasync.core.AppCleaner;
import com.tbyd.data.datasync.core.DataSyncInitializer;
import com.tbyd.data.datasync.core.DataSyncWriter;
import com.tbyd.data.datasync.core.RecordHandler;
import io.debezium.embedded.Connect;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.spi.OffsetCommitPolicy;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.util.Properties;

@Slf4j
public class Main {

    public static void main(String[] args) throws Throwable {
        if (args.length == 0) {
            System.err.println("请指定配置文件");
            return;
        }



        new AppCleaner().cleanBeforeStart();

        Properties props = DebeziumProperties.get();
        Properties dataSyncProps = DataSyncProperties.loadAndValidate(args[0]);
        DebeziumProperties.mergeDataSyncProps(props, dataSyncProps);

        DataSyncInitializer initializer = new DataSyncInitializer();
        initializer.initialize(props);

        RecordHandler recordHandler = new DataSyncWriter(props);
        DebeziumEngine<?> engine = DebeziumEngine.create(Connect.class)
                .using(props)
                .using(OffsetCommitPolicy.always())
                .notifying((records, commiter) -> {
                    try {
                        recordHandler.handleBatch(records, commiter);
                    } catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                }).build();
        addShutdownHook(engine);
        engine.run();
    }

    private static void addShutdownHook(DebeziumEngine<?> engine) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                engine.close();
            } catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        }));
    }
}
