package com.tbyd.data.datasync.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;

public class DebeziumProperties {

    private static final String PROPERTIES_LOCATION = "debezium.properties";

    public static final String DB_PREFIX = "database.";
    public static final String DB_HOST_KEY = DB_PREFIX + "hostname";
    public static final String DB_PORT_KEY = DB_PREFIX + "port";
    public static final String DB_USER_KEY = DB_PREFIX + "user";
    public static final String DB_PASSWORD_KEY = DB_PREFIX + "password";
    public static final String DB_DBNAME_KEY = DB_PREFIX + "dbname";

    public static final String CAPTURED_TABLES_KEY = "table.include.list";

    public static Properties get() {
        ClassLoader cld = DebeziumProperties.class.getClassLoader();
        try (InputStream is = cld.getResourceAsStream(PROPERTIES_LOCATION)) {
            Properties props = new Properties();
            props.load(is);
            return props;
        } catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void mergeDataSyncProps(Properties debeziumProps, Properties dataSyncProps) {
        debeziumProps.putAll(dataSyncProps);
        debeziumProps.setProperty(DB_HOST_KEY, DataSyncProperties.getSourceHost(dataSyncProps));
        debeziumProps.setProperty(DB_PORT_KEY, DataSyncProperties.getSourcePort(dataSyncProps));
        debeziumProps.setProperty(DB_USER_KEY, DataSyncProperties.getSourceUser(dataSyncProps));
        debeziumProps.setProperty(DB_PASSWORD_KEY, DataSyncProperties.getSourcePassword(dataSyncProps));
        debeziumProps.setProperty(DB_DBNAME_KEY, DataSyncProperties.getSourceDbname(dataSyncProps));
        String schema = DataSyncProperties.getSourceUser(dataSyncProps).toUpperCase();
        String tables = DataSyncProperties.getSyncTableNames(dataSyncProps);
        String schemaTables = Arrays.stream(tables.split(",")).map(tableName -> schema + "." + tableName).collect(Collectors.joining(","));
        debeziumProps.setProperty(CAPTURED_TABLES_KEY, schemaTables);
        debeziumProps.setProperty("schema.include.list", schema);
    }
}
