package com.tbyd.data.datasync.core;

import com.tbyd.data.datasync.config.DataSyncProperties;
import lombok.extern.slf4j.Slf4j;

import java.sql.Connection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.stream.Collectors;

@Slf4j
public class DataSyncInitializer {

    private static final String DBO_SCHEMA_ID = "dbo";

    public void initialize(Properties props) {
        String sourceHost = DataSyncProperties.getSourceHost(props);
        String sourcePort = DataSyncProperties.getSourcePort(props);
        String sourceUser = DataSyncProperties.getSourceUser(props);
        String sourcePassword = DataSyncProperties.getSourcePassword(props);
        String sourceDbname = DataSyncProperties.getSourceDbname(props);
        String[] syncTableNames = DataSyncProperties.getSyncTableNamesArray(props);
        try {
            Connection conn = DBUtils.getConn(sourceHost, sourcePort, sourceDbname, sourceUser, sourcePassword);
            CdcHelper.enableDBSupplementalLogging(conn);
            DBUtils.closeResource(conn);

            conn = DBUtils.getConn(sourceHost, sourcePort, sourceDbname, sourceUser, sourcePassword);
            CdcHelper.enableSchemaTablesSupplementalLogging(conn, sourceUser,
                    new HashSet<>(Arrays.asList(syncTableNames))
                            .stream()
                            .map(DataSyncInitializer::stripSchema)
                            .collect(Collectors.toSet()));
            DBUtils.closeResource(conn);

        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new IllegalStateException("初始化失败", e);
        }
    }

    public static String stripSchema(String fullName) {
        return fullName.substring(fullName.indexOf(".") + 1);
    }


}
