package com.tbyd.data.datasync.core;

import com.tbyd.data.datasync.config.DataSyncProperties;
import lombok.extern.slf4j.Slf4j;

import java.sql.Connection;
import java.util.Properties;

@Slf4j
public class DataSyncInitializer {

    private static final String DBO_SCHEMA_ID = "dbo";

    public void initialize(Properties props) {
        String sourceHost = DataSyncProperties.getSourceHost(props);
        String sourcePort = DataSyncProperties.getSourcePort(props);
        String sourceUser = DataSyncProperties.getSourceUser(props);
        String sourcePassword = DataSyncProperties.getSourcePassword(props);
        String sourceDbname = DataSyncProperties.getSourceDbname(props);
        String[] syncTableNames = DataSyncProperties.getSyncTableNamesArray(props);
        try {
            Connection conn = DBUtils.getConn(sourceHost, sourcePort, sourceUser, sourcePassword);
            CdcHelper.enableDBCdcIfNeeded(conn, sourceDbname);
            DBUtils.closeResource(conn);
            for (String tableName : syncTableNames) {
                conn = DBUtils.getConn(sourceHost, sourcePort, sourceUser, sourcePassword);
                CdcHelper.enableTableCdcIfNeeded(conn, sourceDbname, stripSchemaId(tableName));
                DBUtils.closeResource(conn);
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new IllegalStateException("初始化失败", e);
        }
    }

    private static String stripSchemaId(String tableName) {
        String schemaIdPrefix = DBO_SCHEMA_ID + ".";
        return tableName.substring(schemaIdPrefix.length());
    }
}
