package com.tbyd.data.datasync.core;

import lombok.Data;

import java.util.Map;
import java.util.Set;

@Data
public class TableMetadata {

    private String tableName;
    private int columnCount;
    private String[] columnNames;
    private Map<String, Integer> columnIndexes;
    private Set<String> keys;

    public Integer getIndex(String column) {
        return columnIndexes.get(column);
    }

    public String[] getKeysArray() {
        return keys.toArray(new String[0]);
    }
}
