const chartTypes = [
  {
    name: '表格', value: 'table', icon: 'chart_table',
    status: true,
    rule: {
      text: '0个或多个 行维;0个或多个 列维;0个或多个 指标',
      check(rows, columns, measures) {
        return rows.length >= 0 && columns.length >= 0 && measures.length >= 0
      }
    }
  },
  {
    name: '折线图', value: 'line', icon: 'chart_line',
    status: true,
    rule: {
      text: '1个或多个 行维;0个或多个 列维;1个或多个 指标',
      check(rows, columns, measures) {
        return rows.length >= 1 && columns.length >= 0 && measures.length >= 1
      }
    }
  },
  {
    name: '柱状图', value: 'bar', icon: 'chart_bar',
    status: true,
    rule: {
      text: '1个或多个 行维;0个或多个 列维;1个或多个 指标',
      check(rows, columns, measures) {
        return rows.length >= 1 && columns.length >= 0 && measures.length >= 1
      }
    }
  },
  {
    name: '饼图', value: 'pie', icon: 'chart_pie',
    status: true,
    rule: {
      text: '1个或多个 行维;0个或多个 列维;1个或多个 指标',
      check(rows, columns, measures) {
        return rows.length >= 1 && columns.length >= 0 && measures.length >= 1
      }
    }
  },
  {
    name: '指标卡', value: 'kpi', icon: 'chart_kpi',
    status: true,
    rule: {
      text: '0 行维;0 列维;1 指标',
      check(rows, columns, measures) {
        return rows.length === 0 && columns.length === 0 && measures.length === 1
      }
    }
  },
  {
    name: '雷达图', value: 'radar', icon: 'chart_radar',
    status: true,
    rule: {
      text: '1个或多个 行维;0个或多个 列维;1个或多个 指标',
      check(rows, columns, measures) {
        return rows.length >= 1 && columns.length >= 0 && measures.length >= 1
      }
    }
  },
  {
    name: '漏斗图', value: 'funnel', icon: 'chart_funnel',
    status: true,
    rule: {
      text: '0个或多个 行维;0 列维;1个或多个 指标',
      check(rows, columns, measures) {
        return rows.length >= 0 && columns.length === 0 && measures.length >= 1
      }
    }
  },
  {
    name: '散点图', value: 'scatter', icon: 'chart_scatter',
    status: true,
    rule: {
      text: '1个或多个 行维;0个或多个 列维;1个或多个 指标',
      check(rows, columns, measures) {
        return rows.length >= 1 && columns.length >= 0 && measures.length >= 1
      }
    }
  },
  {
    name: '仪表盘', value: 'gauge', icon: 'chart_gauge',
    status: true,
    rule: {
      text: '0 行维;0 列维;1 指标',
      check(rows, columns, measures) {
        return rows.length === 0 && columns.length === 0 && measures.length === 1
      }
    }
  },
  {
    name: '矩形树图', value: 'treemap', icon: 'chart_treemap',
    status: true,
    rule: {
      text: '1个或多个 行维;0 列维;1 指标',
      check(rows, columns, measures) {
        return rows.length >= 1 && columns.length === 0 && measures.length === 1
      }
    }
  },
  {
    name: '词云图', value: 'wordcloud', icon: 'chart_wordcloud',
    status: true,
    rule: {
      text: '1个或多个 行维;0 列维;1 指标',
      check(rows, columns, measures) {
        return rows.length >= 1 && columns.length === 0 && measures.length === 1
      }
    }
  },
  {
    name: '水球图', value: 'liquidfill', icon: 'chart_liquidfill',
    status: true,
    rule: {
      text: '0 行维;0 列维;1 指标',
      check(rows, columns, measures) {
        return rows.length === 0 && columns.length === 0 && measures.length === 1
      }
    }
  },
  {
    name: '桑基图', value: 'sankey', icon: 'chart_sankey',
    status: true,
    rule: {
      text: '1个或多个 行维;0个或多个 列维;1 指标',
      check(rows, columns, measures) {
        return rows.length >= 1 && columns.length >= 0 && measures.length === 1
      }
    }
  },
  {
    name: '地图', value: 'geo', icon: 'chart_geo',
    status: true,
    rule: {
      text: '1个或多个 行维;0个或多个 列维;1个或多个 指标',
      check(rows, columns, measures) {
        return rows.length >= 1 && columns.length >= 0 && measures.length >= 1
      }
    }
  },
  {
    name: '树图', value: 'tree', icon: 'chart_tree',
    status: false,
    rule: {
      text: '0 行维;0 列维;0 指标',
      check(rows, columns, measures) {
        return rows.length === 0 && columns.length === 0 && measures.length === 0
      }
    }
  },
  {
    name: '环形图', value: 'donut', icon: 'chart_donut',
    status: false,
    rule: {
      text: '0 行维;0 列维;0 指标',
      check(rows, columns, measures) {
        return rows.length === 0 && columns.length === 0 && measures.length === 0
      }
    }
  },
  {
    name: '旭日图', value: 'sunburst', icon: 'chart_sunburst',
    status: false,
    rule: {
      text: '0 行维;0 列维;0 指标',
      check(rows, columns, measures) {
        return rows.length === 0 && columns.length === 0 && measures.length === 0
      }
    }
  },
  {
    name: '极区图', value: 'polar', icon: 'chart_polar',
    status: false,
    rule: {
      text: '0 行维;0 列维;0 指标',
      check(rows, columns, measures) {
        return rows.length === 0 && columns.length === 0 && measures.length === 0
      }
    }
  }
]

export default chartTypes
