package cn.datax.service.data.market.api.call.service.impl;

import cn.datax.common.base.BaseServiceImpl;
import cn.datax.service.data.market.api.call.dao.ApiLogDao;
import cn.datax.service.data.market.api.call.mapstruct.ApiLogMapper;
import cn.datax.service.data.market.api.call.service.ApiLogService;
import cn.datax.service.data.market.api.dto.ApiLogDto;
import cn.datax.service.data.market.api.entity.ApiLogEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class ApiLogServiceImpl extends BaseServiceImpl<ApiLogDao, ApiLogEntity> implements ApiLogService {

    @Autowired
    private ApiLogDao apiLogDao;

    @Autowired
    private ApiLogMapper apiLogMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveApiLog(ApiLogDto apiLogDto) {
        ApiLogEntity apiLog = apiLogMapper.toEntity(apiLogDto);
        apiLogDao.insert(apiLog);
    }
}
