package cn.datax.common.security.config;

import cn.datax.common.security.interceptor.DataServerProtectInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 微服务防护配置
 *
 * @author yuwei
 */
@ComponentScan({"cn.datax.common.security.interceptor"})
@Import({DataServerProtectInterceptor.class})
public class DataServerProtectConfiguration implements WebMvcConfigurer {

    @Autowired
    private DataServerProtectInterceptor dataServerProtectInterceptor;

    @Bean
    @ConditionalOnMissingBean(value = PasswordEncoder.class)
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(dataServerProtectInterceptor);
    }
}
