package cn.datax.service.system.api.feign.fallback;

import cn.datax.common.core.R;
import cn.datax.service.system.api.feign.UserServiceFeign;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@AllArgsConstructor
public class UserServiceFeignFallbackImpl implements UserServiceFeign {

    private final Throwable cause;

    @Override
    public R getUserByUsername(String username) {
        log.error("feign 调用用户{}出错,信息:{}", username, cause.getLocalizedMessage());
        return null;
    }
}
