package cn.datax.service.data.factory.api.feign;

import cn.datax.common.core.R;
import cn.datax.service.data.factory.api.feign.factory.DataSourceServiceFeignFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@FeignClient(contextId = "dataSourceServiceFeign", value = "datax-service-data-factory", fallbackFactory = DataSourceServiceFeignFallbackFactory.class)
public interface DataSourceServiceFeign {

    @GetMapping("/dataSource/{id}")
    R getDataSourceById(@PathVariable("id") String id);
}
