package cn.datax.service.system.api.dto;

import cn.datax.common.validate.ValidationGroups;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
/**
 * <p>
 * 工作流配置信息表 实体DTO
 * </p>
 *
 * @author yuwei
 * @since 2020-05-19
 */
@ApiModel(value = "工作流配置信息表Model")
@Data
public class WorkflowConfigDto implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "主键ID")
    @NotBlank(message = "主键ID不能为空", groups = {ValidationGroups.Update.class})
    private String id;
    @ApiModelProperty(value = "流程定义")
    @NotBlank(message = "流程定义不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String procesKey;
    @ApiModelProperty(value = "业务主题")
    @NotBlank(message = "业务主题不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String businessTheme;
    @ApiModelProperty(value = "业务编码")
    @NotBlank(message = "业务编码不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String businessCode;
    @ApiModelProperty(value = "业务组件")
    @NotBlank(message = "业务组件不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String businessComponent;
}
