package cn.datax.service.system.config;

import cn.datax.common.core.DataConstant;
import cn.datax.common.redis.service.RedisService;
import cn.datax.service.system.api.entity.DictEntity;
import cn.datax.service.system.dao.DictDao;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Component
@RequiredArgsConstructor
public class StartedUpRunner implements ApplicationRunner {

    private final ConfigurableApplicationContext context;
    private final Environment environment;

    @Autowired
    private RedisService redisService;
    @Autowired
    private DictDao dictDao;

    @Override
    public void run(ApplicationArguments args) {
        if (context.isActive()) {
            String banner = "-----------------------------------------\n" +
                    "服务启动成功，时间：" + DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()) + "\n" +
                    "服务名称：" + environment.getProperty("spring.application.name") + "\n" +
                    "端口号：" + environment.getProperty("server.port") + "\n" +
                    "-----------------------------------------";
            System.out.println(banner);

            // 项目启动时，初始化缓存
            String key = "data:system:dicts";
            Boolean hasKey = redisService.hasKey(key);
            if (!hasKey) {
                List<DictEntity> dictEntityList = dictDao.queryDictList(DataConstant.EnableState.ENABLE.getKey());
                redisService.set(key, dictEntityList);
            }
        }
    }
}
