package cn.datax.service.system.controller;

import cn.datax.common.core.JsonPage;
import cn.datax.common.core.R;
import cn.datax.common.validate.ValidationGroups;
import cn.datax.service.system.api.dto.SysConfigDto;
import cn.datax.service.system.api.entity.SysConfigEntity;
import cn.datax.service.system.api.vo.SysConfigVo;
import cn.datax.service.system.api.query.SysConfigQuery;
import cn.datax.service.system.mapstruct.SysConfigMapper;
import cn.datax.service.system.service.SysConfigService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 系统参数配置信息表 前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2020-05-19
 */
@Api(tags = {"系统参数配置信息表"})
@RestController
@RequestMapping("/sysConfigs")
public class SysConfigController extends BaseController {

    @Autowired
    private SysConfigService sysConfigService;

    @Autowired
    private SysConfigMapper sysConfigMapper;

    /**
     * 通过ID查询信息
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "获取详细信息", notes = "根据url的id来获取详细信息")
    @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path")
    @GetMapping("/{id}")
    public R getSysConfigById(@PathVariable String id) {
        SysConfigEntity sysConfigEntity = sysConfigService.getSysConfigById(id);
        return R.ok().setData(sysConfigMapper.toVO(sysConfigEntity));
    }

    /**
     * 分页查询信息
     *
     * @param sysConfigQuery
     * @return
     */
    @ApiOperation(value = "分页查询", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "sysConfigQuery", value = "查询实体sysConfigQuery", required = true, dataTypeClass = SysConfigQuery.class)
    })
    @GetMapping("/page")
    public R getSysConfigPage(SysConfigQuery sysConfigQuery) {
        QueryWrapper<SysConfigEntity> queryWrapper = new QueryWrapper<>();
        IPage<SysConfigEntity> page = sysConfigService.page(new Page<>(sysConfigQuery.getPageNum(), sysConfigQuery.getPageSize()), queryWrapper);
        List<SysConfigVo> collect = page.getRecords().stream().map(sysConfigMapper::toVO).collect(Collectors.toList());
        JsonPage<SysConfigVo> jsonPage = new JsonPage<>(page.getCurrent(), page.getSize(), page.getTotal(), collect);
        return R.ok().setData(jsonPage);
    }

    /**
     * 添加
     * @param sysConfig
     * @return
     */
    @ApiOperation(value = "添加信息", notes = "根据sysConfig对象添加信息")
    @ApiImplicitParam(name = "sysConfig", value = "详细实体sysConfig", required = true, dataType = "SysConfigDto")
    @PostMapping()
    public R saveSysConfig(@RequestBody @Validated({ValidationGroups.Insert.class}) SysConfigDto sysConfig) {
        sysConfigService.saveSysConfig(sysConfig);
        return R.ok();
    }

    /**
     * 修改
     * @param sysConfig
     * @return
     */
    @ApiOperation(value = "修改信息", notes = "根据url的id来指定修改对象，并根据传过来的信息来修改详细信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path"),
            @ApiImplicitParam(name = "sysConfig", value = "详细实体sysConfig", required = true, dataType = "SysConfigDto")
    })
    @PutMapping("/{id}")
    public R updateSysConfig(@PathVariable String id, @RequestBody @Validated({ValidationGroups.Update.class}) SysConfigDto sysConfig) {
        sysConfigService.updateSysConfig(sysConfig);
        return R.ok();
    }

    /**
     * 删除
     * @param id
     * @return
     */
    @ApiOperation(value = "删除", notes = "根据url的id来指定删除对象")
    @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path")
    @DeleteMapping("/{id}")
    public R deleteSysConfigById(@PathVariable String id) {
        sysConfigService.deleteSysConfigById(id);
        return R.ok();
    }
}
