package cn.datax.service.data.factory.api.dto;

import cn.datax.common.validate.ValidationGroups;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
/**
 * <p>
 * 数据集信息表 实体DTO
 * </p>
 *
 * @author yuwei
 * @since 2020-03-20
 */
@ApiModel(value = "数据集信息表Model")
@Data
public class DataSetDto implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "主键ID")
    @NotBlank(message = "主键ID不能为空", groups = {ValidationGroups.Update.class})
    private String id;
    @ApiModelProperty(value = "数据源")
    @NotBlank(message = "数据源不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String sourceId;
    @ApiModelProperty(value = "数据集名称")
    @NotBlank(message = "数据集名称不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String setName;
    @ApiModelProperty(value = "数据集sql")
    @NotBlank(message = "数据集sql不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String setSql;
    @ApiModelProperty(value = "备注")
    private String remark;
}
