package cn.datax.service.data.standard.service.impl;

import cn.datax.service.data.standard.api.entity.ContrastEntity;
import cn.datax.service.data.standard.api.dto.ContrastDto;
import cn.datax.service.data.standard.service.ContrastService;
import cn.datax.service.data.standard.mapstruct.ContrastMapper;
import cn.datax.service.data.standard.dao.ContrastDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 对照表信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-09-27
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class ContrastServiceImpl extends BaseServiceImpl<ContrastDao, ContrastEntity> implements ContrastService {

    @Autowired
    private ContrastDao contrastDao;

    @Autowired
    private ContrastMapper contrastMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContrastEntity saveContrast(ContrastDto contrastDto) {
        ContrastEntity contrast = contrastMapper.toEntity(contrastDto);
        contrastDao.insert(contrast);
        return contrast;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContrastEntity updateContrast(ContrastDto contrastDto) {
        ContrastEntity contrast = contrastMapper.toEntity(contrastDto);
        contrastDao.updateById(contrast);
        return contrast;
    }

    @Override
    public ContrastEntity getContrastById(String id) {
        ContrastEntity contrastEntity = super.getById(id);
        return contrastEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteContrastById(String id) {
        contrastDao.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteContrastBatch(List<String> ids) {
        contrastDao.deleteBatchIds(ids);
    }

    @Override
    public void getContrastTree() {

    }
}
