package cn.datax.system.api.dto;

import cn.datax.common.validate.ValidateGroupForSave;
import cn.datax.common.validate.ValidateGroupForUpdate;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
public class RoleDto implements Serializable {

    private static final long serialVersionUID=1L;

    @NotBlank(message = "主键ID不能为空", groups = {ValidateGroupForUpdate.class})
    private String id;

    @NotBlank(message = "角色名称不能为空", groups = {ValidateGroupForSave.class, ValidateGroupForUpdate.class})
    private String roleName;

    @NotBlank(message = "角色编码不能为空", groups = {ValidateGroupForSave.class, ValidateGroupForUpdate.class})
    private String roleCode;

}
